package com.lwtek.demo;

import android.os.Bundle;
import android.view.View;

import androidx.appcompat.app.AppCompatActivity;

import com.lwtek.demo.databinding.ActivityFunctionBinding;

public class FunctionActivity extends AppCompatActivity implements View.OnClickListener {

    private ActivityFunctionBinding binding;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityFunctionBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        initView();
    }

    private void initView() {
        binding.timingBtn.setOnClickListener(this);
        binding.shutdownBtn.setOnClickListener(this);
        binding.restoreBtn.setOnClickListener(this);
    }

    public void onClick(View v) {
        int id = v.getId();
        if (id == binding.timingBtn.getId()) {
            MyApplication.getDevice().timing();
        } else if (id == binding.shutdownBtn.getId()) {
            MyApplication.getDevice().shutdown();
        } else if (id == binding.restoreBtn.getId()) {
            MyApplication.getDevice().restoreSetting();
        }
    }
}